<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Person>
 */
class PersonFactory extends Factory
{
    public function definition(): array
    {
        $names = $this->faker->name();
        $father_last_name = $this->faker->lastName();
        $mother_last_name = $this->faker->lastName();
        return [
            'document' => $this->faker->unique()->numerify('#########'),
            'names' => $names,
            'father_last_name' => $father_last_name,
            'mother_last_name' => $mother_last_name,
            'full_name' => $names . ' ' . $father_last_name . ' ' . $mother_last_name,
            'gender' => $this->faker->randomElement(['m', 'f']),
            'birthday' => $this->faker->date(),
        ];
    }
}
