<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Company>
 */
class CompanyFactory extends Factory
{
    public function definition(): array
    {
        return [
            'ruc' => $this->faker->unique()->numerify('##############'),
            'business_name' => $this->faker->company(),
            'condition' => $this->faker->randomElement(['NATURAL PERSON', 'LEGAL PERSON']),
            'tradename' => $this->faker->company(),
            'type' => $this->faker->randomElement(['ACTIVITIES', 'INSTITUTION']),
            'registration_date' => $this->faker->date(),
            'status' => $this->faker->randomElement(['ACTIVO', 'INACTIVO']),
            'address' => $this->faker->address(),
            'emission_system' => $this->faker->randomElement(['NATURAL PERSON', 'LEGAL PERSON']),
            'outside_activity' => $this->faker->randomElement(['NATURAL PERSON', 'LEGAL PERSON']),
            'accounting_system' => $this->faker->randomElement(['NATURAL PERSON', 'LEGAL PERSON']),
            'electronic_issue_date' => $this->faker->date(),
            'department' => $this->faker->country(),
            'province' => $this->faker->country(),
            'district' => $this->faker->country(),
        ];
    }
}
