<?php

namespace App\Http\Controllers;

use App\Models\Person;
use Carbon\Carbon;
use Illuminate\Http\Request;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;

class PersonController extends Controller
{
    public function getPerson($document)
    {
        $person = Person::find($document);

        if ($person) {
            // Log::info('Persona Encontrada en la BD');
            // Log::info($person);
            return response()->json([
                'status' => true,
                'message' => 'Persona Encontrada en la BD',
                'information' => $person
            ]);
        } else {
            // Llama a la función getPersonFromApi
            $apiResponse = $this->getPersonFromApi($document);
            // Log::info('Respuesta de la API');
            // Log::info($apiResponse);

            if ($apiResponse['estado']) {
                $dataPersonResponse = $this->registerPerson($apiResponse['data']);
                $dataPerson = json_decode($dataPersonResponse->getContent(), true);
                return response()->json([
                    'status' => true,
                    'message' => 'Persona Encontrada en la API',
                    'information' => $dataPerson['information']
                ]);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'Persona no encontrada',
                    'information' => null
                ]);
            }
        }
    }

    public function getPersonFromApi($document)
    {
        // Crea una instancia del cliente Guzzle
        $client = new Client();
        // Define la URL de la API y el token de autenticación
        $url = 'https://api.perudevs.com/api/v1/dni/complete';
        $token = 'cGVydWRldnMucHJvZHVjdGlvbi5maXRjb2RlcnMuNjY0NGFlYTBkNDFiOTQxMTE0OGI1N2Nk';
        Log::info("$url?document=$document&key=$token");
        // Realiza la solicitud GET a la API
        try {
            $response = $client->request('GET', "$url?document=$document&key=$token", [
                'headers' => [
                    'Accept' => 'application/json',
                ],
            ]);

            // Obtiene el cuerpo de la respuesta
            $data = json_decode($response->getBody(), true);
            Log::info($data);
            // Verifica si la respuesta es válida y contiene los datos necesarios
            if ($data['estado']) {
                return [
                    'estado' => true,
                    'data' => $data['resultado']
                ];
            } else {
                return [
                    'estado' => false,
                    'data' => null
                ];
            }
        } catch (\Exception $e) {
            // Manejo de errores
            return [
                'estado' => false,
                'data' => null
            ];
        }
    }

    public function registerPerson($data)
    {
        // Convertir la fecha al formato Y-m-d
        $data['fecha_nacimiento'] = Carbon::createFromFormat('d/m/Y', $data['fecha_nacimiento'])->format('Y-m-d');

        $person = Person::create([
            'id' => $data['id'],
            'document' => $data['id'],
            'names' => $data['nombres'],
            'father_last_name' => $data['apellido_paterno'],
            'mother_last_name' => $data['apellido_materno'],
            'full_name' => $data['nombre_completo'],
            'gender' => $data['genero'],
            'birthday' => $data['fecha_nacimiento'],
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Persona Registrada',
            'information' => $person
        ]);
    }
}
