<?php

use App\Http\Controllers\Api\Admin\CareerController;
use App\Http\Controllers\Api\Admin\CountryController;
use App\Http\Controllers\Api\Admin\DepartmentController;
use App\Http\Controllers\Api\Admin\DiscountTypeController;
use App\Http\Controllers\Api\Admin\DistrictController;
use App\Http\Controllers\Api\Admin\ProvinceController;
use App\Http\Controllers\Api\Admin\SchoolController;
use App\Http\Controllers\Api\Admin\StudentController;
use App\Http\Controllers\Api\Shared\FileStorageController;
use Illuminate\Support\Facades\Route;

// Catálogos geográficos (solo lectura)
Route::get('/countries', [CountryController::class, 'index']);
Route::get('/departments', [DepartmentController::class, 'index']);
Route::get('/provinces', [ProvinceController::class, 'index']);
Route::get('/districts', [DistrictController::class, 'index']);
Route::get('/districts/{id}', [DistrictController::class, 'show']);

// Catálogos académicos (solo lectura)
Route::get('/schools', [SchoolController::class, 'index']);
Route::get('/careers', [CareerController::class, 'index']);
Route::get('/discount-types', [DiscountTypeController::class, 'index']);
Route::get('/student-enrollment/{id}/detail', [StudentController::class, 'studentDetail']);
// Route::get('/cycles', [CycleController::class, 'index']);

// // Gestión de archivos (usado por todos)
Route::middleware('auth.any:admin,teacher,student')->prefix('files')->group(function () {
    Route::post('/upload', [FileStorageController::class, 'uploadFile']);
    Route::post('/update', [FileStorageController::class, 'updateFile']);
    Route::delete('/delete', [FileStorageController::class, 'deleteFile']);
    Route::get('/display', [FileStorageController::class, 'displayFile']);
    Route::get('/download', [FileStorageController::class, 'downloadFile']);
    Route::get('/check', [FileStorageController::class, 'checkFile']);
    // Genera URL firmada (requiere token para GENERAR)
    Route::post('/get-url', [FileStorageController::class, 'getTemporaryUrl']);
    // Muestra archivo SIN token (valida firma)
    Route::get('/signed/display', [FileStorageController::class, 'displayFileSigned'])
        ->name('files.display.signed')
        ->withoutMiddleware(['auth.any:admin,teacher,student']);
});
