<?php

use App\Http\Controllers\Api\Admin\CareerController;
use App\Http\Controllers\Api\Admin\CountryController;
use App\Http\Controllers\Api\Admin\CycleController;
use App\Http\Controllers\Api\Admin\DepartmentController;
use App\Http\Controllers\Api\Admin\DiscountTypeController;
use App\Http\Controllers\Api\Admin\DistrictController;
use App\Http\Controllers\Api\Admin\EnrollmentController;
use App\Http\Controllers\Api\Admin\EnrollmentPaymentController;
use App\Http\Controllers\Api\Admin\PermissionController;
use App\Http\Controllers\Api\Admin\ProvinceController;
use App\Http\Controllers\Api\Admin\RoleController;
use App\Http\Controllers\Api\Admin\SchoolController;
use App\Http\Controllers\Api\Admin\StudentController;
use App\Http\Controllers\Api\Admin\UserController;
use App\Http\Controllers\Api\AdminController;
use App\Http\Controllers\Api\TeacherController;
use App\Http\Controllers\Api\UserRoleController;
use Illuminate\Support\Facades\Route;

// ============================================================================
// AUTENTICACIÓN Y PERFIL (sin permisos específicos, solo auth.admin)
// ============================================================================
Route::post('/logout', [UserController::class, 'logout']);

Route::get('/profile', [UserController::class, 'profile']);
Route::put('/profile', [UserController::class, 'updateProfile']);


// ============================================================================
// GESTIÓN DE PERMISOS
// ============================================================================
Route::get('/permissions', [PermissionController::class, 'index'])->middleware(['permission:permissions.index']);
Route::get('/permissions/groups', [PermissionController::class, 'groups'])->middleware(['permission:permissions.index']);
Route::get('/permissions/{id}', [PermissionController::class, 'show'])->middleware(['permission:permissions.show']);
Route::post('/permissions', [PermissionController::class, 'store'])->middleware(['permission:permissions.store']);
Route::put('/permissions/{id}', [PermissionController::class, 'update'])->middleware(['permission:permissions.update']);
Route::patch('/permissions/{id}/toggle-status', [PermissionController::class, 'toggleStatus'])->middleware(['permission:permissions.update']);
Route::delete('/permissions/{id}', [PermissionController::class, 'destroy'])->middleware(['permission:permissions.destroy']);

// ============================================================================
// GESTIÓN DE ROLES
// ============================================================================


Route::get('/roles', [RoleController::class, 'index'])->middleware(['permission:roles.index']);
Route::get('/roles/{id}', [RoleController::class, 'show'])->middleware(['permission:roles.show']);
Route::post('/roles', [RoleController::class, 'store'])->middleware(['permission:roles.store']);
Route::put('/roles/{id}', [RoleController::class, 'update'])->middleware(['permission:roles.update']);
Route::patch('/roles/{id}/toggle-status', [RoleController::class, 'toggleStatus'])->middleware(['permission:roles.update']);
Route::delete('/roles/{id}', [RoleController::class, 'destroy'])->middleware(['permission:roles.destroy']);


// Gestionar permisos de roles (asignar/remover/sincronizar)
Route::middleware(['permission:roles.permissions.sync'])->group(function () {
    Route::post('/roles/{id}/assign-permissions', [RoleController::class, 'assignPermissions']);
    Route::post('/roles/{id}/remove-permissions', [RoleController::class, 'removePermissions']);
    Route::post('/roles/{id}/sync-permissions', [RoleController::class, 'syncPermissions']);
});

// ============================================================================
// GESTIÓN DE USUARIOS (ADMINS)
// ============================================================================
Route::get('/users', [UserController::class, 'index'])->middleware('permission:users.index');
Route::post('/users', [UserController::class, 'store'])->middleware('permission:users.store');
Route::get('/users/{id}', [UserController::class, 'show'])->middleware('permission:users.show');
Route::put('/users/{id}', [UserController::class, 'update'])->middleware('permission:users.update');
Route::delete('/users/{id}', [UserController::class, 'destroy'])->middleware('permission:users.destroy');
Route::patch('/users/{id}/toggle-status', [UserController::class, 'toggleStatus'])->middleware('permission:users.update');
Route::patch('/users/{id}/reset-password', [UserController::class, 'resetPassword'])->middleware('permission:users.update');
Route::patch('/users/{id}/change-password', [UserController::class, 'changePassword'])->middleware('permission:users.update');
Route::post('/users/{id}/sync-roles', [UserController::class, 'syncRoles'])->middleware('permission:users.roles.assign');

// ============================================================================
// GESTIÓN DE ROLES DE USUARIOS/TEACHERS/STUDENTS
// ============================================================================
// Route::prefix('{modelType}/{modelId}/roles')->middleware(['permission:users.edit,teachers.edit,students.edit'])->group(function () {
//     Route::get('/', [UserRoleController::class, 'index']);
//     Route::post('/', [UserRoleController::class, 'attach']);
//     Route::delete('/', [UserRoleController::class, 'detach']);
//     Route::put('/', [UserRoleController::class, 'sync']);
// });


// ============================================================================
// GESTIÓN DE DOCENTES
// ============================================================================
Route::middleware(['permission:teachers.view'])->group(function () {
    Route::get('/teachers', [TeacherController::class, 'index']);
    Route::get('/teachers/{id}', [TeacherController::class, 'show']);
});

Route::middleware(['permission:teachers.edit'])->group(function () {
    Route::patch('/teachers/{id}/toggle-status', [TeacherController::class, 'toggleStatus']);
    Route::patch('/teachers/{id}/reset-password', [TeacherController::class, 'resetPassword']);
    Route::patch('/teachers/{id}/change-password', [TeacherController::class, 'changePassword']);
    Route::put('/teachers/{id}', [TeacherController::class, 'update']);
});

Route::middleware(['permission:teachers.create'])->group(function () {
    Route::post('/teachers', [TeacherController::class, 'store']);
});

Route::middleware(['permission:teachers.delete'])->group(function () {
    Route::delete('/teachers/{id}', [TeacherController::class, 'destroy']);
});

// ============================================================================
// GESTIÓN DE ESTUDIANTES
// ============================================================================

Route::get('/students', [StudentController::class, 'index'])->middleware('permission:students.index');
Route::post('/students', [StudentController::class, 'store'])->middleware('permission:students.store');
Route::get('/students/{id}', [StudentController::class, 'show'])->middleware('permission:students.show');
Route::put('/students/{id}', [StudentController::class, 'update'])->middleware('permission:students.update');
Route::delete('/students/{id}', [StudentController::class, 'destroy'])->middleware('permission:students.destroy');
Route::patch('/students/{id}/toggle-status', [StudentController::class, 'toggleStatus'])->middleware('permission:students.update');
Route::patch('/students/{id}/toggle-validation', [StudentController::class, 'toggleValidation'])->middleware('permission:students.update');
Route::patch('/students/{id}/reset-password', [StudentController::class, 'resetPassword'])->middleware('permission:students.update');

// ============================================================================
// GESTIÓN DE CATÁLOGOS GEOGRÁFICOS
// ============================================================================

// Countries
Route::get('/countries', [CountryController::class, 'index'])->middleware('permission:countries.index');
Route::post('/countries', [CountryController::class, 'store'])->middleware('permission:countries.store');
Route::get('/countries/{id}', [CountryController::class, 'show'])->middleware('permission:countries.show');
Route::put('/countries/{id}', [CountryController::class, 'update'])->middleware('permission:countries.update');
Route::delete('/countries/{id}', [CountryController::class, 'destroy'])->middleware('permission:countries.destroy');

// Departments
Route::get('/departments', [DepartmentController::class, 'index'])->middleware('permission:departments.index');
Route::post('/departments', [DepartmentController::class, 'store'])->middleware('permission:departments.store');
Route::get('/departments/{id}', [DepartmentController::class, 'show'])->middleware('permission:departments.show');
Route::put('/departments/{id}', [DepartmentController::class, 'update'])->middleware('permission:departments.update');
Route::delete('/departments/{id}', [DepartmentController::class, 'destroy'])->middleware('permission:departments.destroy');

// Provinces
Route::get('/provinces', [ProvinceController::class, 'index'])->middleware('permission:provinces.index');
Route::post('/provinces', [ProvinceController::class, 'store'])->middleware('permission:provinces.store');
Route::get('/provinces/{id}', [ProvinceController::class, 'show'])->middleware('permission:provinces.show');
Route::put('/provinces/{id}', [ProvinceController::class, 'update'])->middleware('permission:provinces.update');
Route::delete('/provinces/{id}', [ProvinceController::class, 'destroy'])->middleware('permission:provinces.destroy');

// Districts
Route::get('/districts', [DistrictController::class, 'index'])->middleware('permission:districts.index');
Route::post('/districts', [DistrictController::class, 'store'])->middleware('permission:districts.store');
Route::get('/districts/{id}', [DistrictController::class, 'show'])->middleware('permission:districts.show');
Route::put('/districts/{id}', [DistrictController::class, 'update'])->middleware('permission:districts.update');
Route::delete('/districts/{id}', [DistrictController::class, 'destroy'])->middleware('permission:districts.destroy');


// ============================================================================
// GESTIÓN DE RECURSOS ACADÉMICOS
// ============================================================================
// Schools
Route::get('/schools', [SchoolController::class, 'index'])->middleware('permission:schools.index');
Route::post('/schools', [SchoolController::class, 'store'])->middleware('permission:schools.store');
Route::get('/schools/{id}', [SchoolController::class, 'show'])->middleware('permission:schools.show');
Route::put('/schools/{id}', [SchoolController::class, 'update'])->middleware('permission:schools.update');
Route::delete('/schools/{id}', [SchoolController::class, 'destroy'])->middleware('permission:schools.destroy');

// Careers
Route::get('/careers', [CareerController::class, 'index'])->middleware('permission:careers.index');
Route::post('/careers', [CareerController::class, 'store'])->middleware('permission:careers.store');
Route::get('/careers/{id}', [CareerController::class, 'show'])->middleware('permission:careers.show');
Route::put('/careers/{id}', [CareerController::class, 'update'])->middleware('permission:careers.update');
Route::delete('/careers/{id}', [CareerController::class, 'destroy'])->middleware('permission:careers.destroy');

// Cycles
Route::get('/cycles', [CycleController::class, 'index'])->middleware('permission:cycles.index');
Route::post('/cycles', [CycleController::class, 'store'])->middleware('permission:cycles.store');
Route::get('/cycles/{id}', [CycleController::class, 'show'])->middleware('permission:cycles.show');
Route::put('/cycles/{id}', [CycleController::class, 'update'])->middleware('permission:cycles.update');
Route::delete('/cycles/{id}', [CycleController::class, 'destroy'])->middleware('permission:cycles.destroy');
Route::patch('/cycles/{id}/toggle-enrollment', [CycleController::class, 'toggleEnrollment'])->middleware('permission:cycles.toggle-enrollment');
Route::patch('/cycles/{id}/toggle-active', [CycleController::class, 'toggleActive'])->middleware('permission:cycles.toggle-active');


// GESTIÓN DE MATRÍCULAS (ENROLLMENTS)
Route::prefix('cycles/{cycleId}')->group(function () {

    // Enrollments
    Route::get('/enrollments', [EnrollmentController::class, 'index'])
        ->middleware('permission:enrollments.index');

    Route::get('/enrollments/{enrollmentId}', [EnrollmentController::class, 'show'])
        ->middleware('permission:enrollments.show');

    // Route::put('/enrollments/{enrollmentId}', [EnrollmentController::class, 'update'])
    //     ->middleware('permission:enrollments.update');

    // Route::patch('/enrollments/{enrollmentId}/toggle-status', [EnrollmentController::class, 'toggleStatus'])
    //     ->middleware('permission:enrollments.toggle-status');

    // Payments de una matrícula específica
    // Route::prefix('enrollments/{enrollmentId}/payments')->group(function () {

    //     Route::get('/', [EnrollmentPaymentController::class, 'index'])
    //         ->middleware('permission:enrollments.payments.index');

    //     Route::post('/', [EnrollmentPaymentController::class, 'store'])
    //         ->middleware('permission:enrollments.payments.store');

    //     Route::get('/{paymentId}', [EnrollmentPaymentController::class, 'show'])
    //         ->middleware('permission:enrollments.payments.show');

    //     Route::put('/{paymentId}', [EnrollmentPaymentController::class, 'update'])
    //         ->middleware('permission:enrollments.payments.update');

    //     Route::delete('/{paymentId}', [EnrollmentPaymentController::class, 'destroy'])
    //         ->middleware('permission:enrollments.payments.destroy');

    //     Route::patch('/{paymentId}/toggle-status', [EnrollmentPaymentController::class, 'toggleStatus'])
    //         ->middleware('permission:enrollments.payments.toggle-status');
    // });
});

// Route::get('/enrollments/{enrollmentId}', [EnrollmentController::class, 'show'])
//     ->middleware('permission:enrollments.show');


// Discount Types
Route::get('/discount-types', [DiscountTypeController::class, 'index'])->middleware('permission:discount-types.index');
Route::post('/discount-types', [DiscountTypeController::class, 'store'])->middleware('permission:discount-types.store');
Route::get('/discount-types/{id}', [DiscountTypeController::class, 'show'])->middleware('permission:discount-types.show');
Route::put('/discount-types/{id}', [DiscountTypeController::class, 'update'])->middleware('permission:discount-types.update');
Route::delete('/discount-types/{id}', [DiscountTypeController::class, 'destroy'])->middleware('permission:discount-types.destroy');

// TODO: Agregar gestión de pagos (aprobar, rechazar)
// TODO: Agregar gestión de matrículas (ver todas, cancelar)