<?php

namespace Database\Seeders;

use App\Enums\Gender;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        $user = User::create([
            'document_number' => '12345678',
            'names' => 'John Doe',
            'paternal_surname' => 'Doe',
            'maternal_surname' => 'Vargas',
            'gender' => Gender::Male->value,
            'birth_date' => '1999-07-13',
            'email' => 'vargasvargas@example.com',
            'phone_number' => '1234567890',
            'password' => 'password', // password
            'active' => true,
        ]);

        $user->assignRole('admin');
        // $user->assignRole(['admin', 'teacher', 'student']);
    }
}
