<?php

namespace Database\Seeders;

use App\Enums\DocumentType;
use App\Models\Cycle;
use App\Models\Student;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class StudentSeeder extends Seeder
{
    public function run(): void
    {
        $student = Student::create([
            'document_type' => DocumentType::DNI->value,
            'document_number' => '75469478',
            'names' => 'Ricardo',
            'paternal_surname' => 'Vargas',
            'maternal_surname' => 'Vargas',
            'birth_date' => '1999-07-13',
            'gender' => 'male',
            'phone_number' => '987654321',
            'whatsapp_number' => '987654321',
            'email' => 'vargasvargas@example.com',
            'password' => 'password', //Hash::make('password')
            'validated_information' => false
        ]);

        $cycle = Cycle::getLastActive();

        $student->enrollments()->create([
            'cycle_id' => $cycle->id,
            // 'active' => true,
            'status' => 'pending',
            'registration_steps' => ['personal_data']
        ]);
    }
}
