<?php

namespace Database\Seeders;

use App\Models\School;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class SchoolSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $json = File::get("database/json/schools.json");
        $items = json_decode($json);

        foreach ($items as $key => $value) {
            School::create([
                "id" => $value->id,
                'code' => $value->code,
                'name' => $value->name,
                'sector' => $value->sector,
                'level' => $value->level,
                'ugel' => $value->ugel,
                'district_id' => $value->district_id,
            ]);
        }
    }
}
