<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{
    public function run(): void
    {
        $permissionsConfig = config('permissions');

        foreach ($permissionsConfig as $group => $permissions) {
            foreach ($permissions as $permission) {
                Permission::create([
                    'name' => $permission['name'],
                    'slug' => $permission['slug'],
                    'group' => $group,
                    'description' => $permission['description'] ?? null,
                    'active' => true,
                    'visible' => $permission['visible'] ?? true
                ]);
            }
        }
    }
}
