<?php

namespace Database\Seeders;

use App\Models\Career;
use App\Models\Cycle;
use App\Models\Enrollment;
use App\Models\Student;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Faker\Factory as Faker;

class EnrollmentSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();

        $cycles = Cycle::orderBy('id')->get()->slice(0, -1);

        // Traer de manera aleatoria al 60% de los estudiantes
        $students = Student::where('validated_information', true)->get();
        $studentCount = $students->count();
        $takeCount = (int) round($studentCount * 0.6);
        $selectedStudents = $students->random($takeCount);
        
        foreach ($cycles as $cycle) {
            foreach ($selectedStudents as $student) {
                $hasSchool = $student->school_graduation_year ? true : false;

                $enrollment = Enrollment::create([
                    'student_id' => $student->id,
                    'cycle_id' => $cycle->id,
                    'career_id' => Career::inRandomOrder()->first()->id,
                    'status' => 'closed',
                    'oath_declaration' => true,
                    'grade_school' => $hasSchool ? null : $faker->randomElement([
                        'first',
                        'second',
                        'third',
                        'fourth',
                        'fifth'
                    ]),
                    'file_grade_school' => $hasSchool ? null : 'certificates/' . Str::random(10) . '.pdf',
                    'score' => [
                        'first_note' => 18,
                        'second_note' => 20
                    ],
                    'classroom_id' => null,
                    'registration_steps' => [
                        'personal_data',
                        'additional_information',
                        'family_information',
                        'school_information',
                        'career_information',
                        'file_information',
                        'sworn_declaration',
                        'payment_information',
                        'finish_registration'
                    ],
                    'information_sources' => [
                        'facebook',
                        'tiktok'
                    ]

                ]);
            }
        }
    }
}
