<?php

namespace Database\Seeders;

use App\Models\DiscountType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DiscountTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types = [
            [
                'name' => 'NINGUNO',
                'description' => 'Sin descuento',
                'amount' => 0,
                'active' => true
            ],
            [
                'name' => 'DESCUENTO POR DISCAPACIDAD',
                'description' => 'Descuento por Discapacidad',
                'amount' => 80,
                'active' => true
            ],
            [
                'name' => 'DESCUENTO EXTREMA POBREZA',
                'description' => 'Descuento por Extrema Pobreza',
                'amount' => 60,
                'active' => false
            ],
            [
                'name' => 'DESCUENTO POR HIJO DE TRABAJADOR DE LA UNAJMA',
                'description' => 'Descuento por Hijo de Trabajador de la UNAJMA',
                'amount' => 40,
                'active' => true
            ],
            [
                'name' => 'DESCUENTO POR VIOLENCIA POLITICA',
                'description' => 'Descuento por Violencia Política',
                'amount' => 70,
                'active' => true
            ],
            [
                'name' => 'DESCUENTO POR HERMANOS',
                'description' => 'Descuento por Hermanos',
                'amount' => 10,
                'active' => true
            ],
        ];

        foreach ($types as $type) {
            DiscountType::create($type);
        }
    }
}
