<?php

namespace Database\Seeders;

use App\Models\Cycle;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CycleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $cycles = [
            [
                'name' => '2024-II',
                'year' => 2024,
                'active' => false,
                'enrollment_open' => false,
                'enrollment_start_date' => '2024-01-01',
                'enrollment_end_date' => '2024-03-31',
                'full_payment_cost' => 600.00,
                'installment_cost' => 650.00
            ],
            [
                'name' => '2025-I',
                'year' => 2025,
                'active' => false,
                'enrollment_open' => false,
                'enrollment_start_date' => '2025-04-01',
                'enrollment_end_date' => '2025-06-30',
                'full_payment_cost' => 600.00,
                'installment_cost' => 650.00
            ],
            [
                'name' => '2025-II',
                'year' => 2025,
                'active' => true,
                'enrollment_open' => true,
                'enrollment_start_date' => '2025-07-01',
                'enrollment_end_date' => '2025-09-30',
                'full_payment_cost' => 600.00,
                'installment_cost' => 650.00
            ],
        ];

        foreach ($cycles as $cycle) {
            Cycle::create($cycle);
        }
    }
}
