<?php

namespace Database\Seeders;

use App\Models\Career;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CareerSeeder extends Seeder
{
    public function run(): void
    {
        $careers = [
            [
                'name' => 'Matemáticas y Estadísticas Aplicadas',
                'code' => 'EPMEA',
                'logo' => null,
                'group' => 'a',
                'active' => true
            ],
            [
                'name' => 'Ingeniería de Sistemas',
                'code' => 'EPIS',
                'logo' => null,
                'group' => 'a',
                'active' => true
            ],
            [
                'name' => 'Ingeniería Agroindustrial',
                'code' => 'EPIA',
                'logo' => null,
                'group' => 'a',
                'active' => true
            ],
            [
                'name' => 'Ingeniería Ambiental',
                'code' => 'EPIAM',
                'logo' => null,
                'group' => 'a',
                'active' => true
            ],
            [
                'name' => 'Ingeniería Civil',
                'code' => 'EPIC',
                'logo' => null,
                'group' => 'a',
                'active' => true
            ],
            [
                'name' => 'Psicología',
                'code' => 'EPP',
                'logo' => null,
                'group' => 'b',
                'active' => true
            ],
            [
                'name' => 'Enfermería',
                'code' => 'EPE',
                'logo' => null,
                'group' => 'b',
                'active' => true
            ],
            [
                'name' => 'Administración de Empresas',
                'code' => 'EPAE',
                'logo' => null,
                'group' => 'c',
                'active' => true
            ],
            [
                'name' => 'Contabilidad',
                'code' => 'EPC',
                'logo' => null,
                'group' => 'c',
                'active' => true
            ],
            [
                'name' => 'Educación Primaria Intercultural',
                'code' => 'EPEPI',
                'logo' => null,
                'group' => 'c',
                'active' => true
            ],
        ];

        foreach ($careers as $career) {
            Career::create($career);
        }
    }
}
