<?php

use App\Enums\PaymentStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
             $table->uuid('uuid')->nullable()->unique();
            $table->string('slug')->nullable()->unique();
            $table->string('method')->comment('Método de pago');
            $table->string('concept')->comment('Concepto de pago')->default('Enrollment');
            $table->foreignId('enrollment_id')->constrained()->comment('Matrícula');
            $table->date('payment_date')->comment('Fecha de pago');
            $table->decimal('amount', 10, 2)->comment('Monto de pago');
            $table->string('receipt_number')->unique()->nullable('Numero de recibo');
            $table->string('document_number')->nullable()->comment('DNI del que realizo el pago');
            $table->string('full_name')->nullable()->comment('Nombre completo del que realizo el pago');
            $table->string('comment')->nullable()->comment('Comentario');
            $table->text('file')->nullable()->comment('Archivo adjunto');
            $table->enum('status', PaymentStatus::values())->default(PaymentStatus::Pending->value)->comment('Estado del pago');
            $table->foreignId('approved_by')->nullable()->constrained('users')->comment('Aprobado por');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
