<?php

use App\Enums\Gender;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('teachers', function (Blueprint $table) {
            $table->id();

            // Identificadores únicos
            $table->uuid('uuid')->nullable()->unique();
            $table->string('slug')->nullable()->unique();
            // Datos personales
            $table->string('document_number')->unique()->comment('DNI del docente');
            $table->string('names');
            $table->string('paternal_surname');
            $table->string('maternal_surname');
            $table->enum('gender', Gender::values())->comment('Genero del docente');
            $table->date('birth_date')->comment('Fecha de nacimiento del docente');

            // Datos de contacto
            $table->string('email')->unique()->comment('Correo del docente');
            $table->string('phone_number')->comment('Teléfono del docente');

            // Datos adicionales
            $table->string('photo_profile')->nullable()->comment('Foto de perfil del Usuario');

            // Estados y control
            $table->boolean('active')->default(true)->comment('Activo o inactivo el docente');

            // Campos de autenticación y sesión
            $table->string('password');
            $table->text('access_token')->nullable();
            $table->timestamp('token_expires_at')->nullable();
            $table->timestamp('last_login_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('teachers');
    }
};
