<?php

use App\Enums\EnrollmentStatus;
use App\Enums\GradeSchool;
use App\Enums\PaymentType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('enrollments', function (Blueprint $table) {
            $table->id();

            // Identificadores únicos
            $table->uuid('uuid')->nullable()->unique();

            // Datos personales
            $table->foreignId('student_id')->constrained()->comment('Estudiante');
            $table->foreignId('cycle_id')->constrained()->comment('Ciclo');
            $table->foreignId('career_id')->nullable()->constrained()->comment('Carrera Profesional');
            $table->enum('status', EnrollmentStatus::values())->default(EnrollmentStatus::Pending->value)->comment('Estado');
            $table->boolean('oath_declaration')->default(false)->comment('Declaración jurada');
            $table->enum('grade_school', GradeSchool::values())->nullable()->comment('Grado escolar');
            $table->string('file_grade_school')->nullable()->comment('Archivo de grado escolar');
            $table->json('score')->nullable()->comment('Calificaciones');
            $table->json('information_sources')->nullable()->comment('Fuentes de información');
            $table->foreignId('classroom_id')->nullable()->constrained()->comment('Aula');
            $table->json('registration_steps')->nullable()->comment('Pasos de inscripción');

            // Pagos
            $table->decimal('total_amount', 10, 2)->nullable()->comment('Monto de Total');
            $table->enum('payment_type', PaymentType::values())->nullable()->comment('Tipo de pago elegido');

            // Descuentos
            $table->foreignId('discount_type_id')->nullable()->constrained('discount_types')->comment('Tipo de descuento');
            $table->decimal('discount_amount', 10, 2)->default(0)->comment('Monto de descuento');
            $table->text('discount_file')->nullable()->comment('Archivo de descuento');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('enrollments');
    }
};
