<?php

use App\Enums\DocumentType;
use App\Enums\MaritalStatus;
use App\Enums\Gender;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();

            // Identificadores únicos
            $table->uuid('uuid')->nullable()->unique();
            $table->string('slug')->nullable()->unique();

            // Datos personales
            $table->enum('document_type', DocumentType::values())->default(DocumentType::DNI->value);
            $table->string('document_number')->unique();
            $table->string('names');
            $table->string('paternal_surname');
            $table->string('maternal_surname');
            $table->date('birth_date')->nullable();
            $table->foreignId('birth_place_id')->nullable()->constrained('districts');
            $table->enum('marital_status', MaritalStatus::values())->nullable();
            $table->enum('gender', Gender::values())->nullable();
            $table->json('languages')->nullable();

            // Datos de contacto
            $table->string('phone_number')->nullable();
            $table->string('whatsapp_number')->nullable();
            $table->string('email')->nullable();
            $table->string('residence_address')->nullable();
            $table->foreignId('residence_place_id')->nullable()->constrained('districts');

            // Datos académicos
            $table->year('school_graduation_year')->nullable();
            $table->string('school_graduation_certificate')->nullable();
            $table->foreignId('school_id')->nullable()->constrained();

            // Datos adicionales
            $table->json('family_data')->nullable();
            $table->string('document_file')->nullable();
            $table->string('photo_student')->nullable();

            // Estados
            $table->boolean('active')->default(true);
            $table->boolean('validated_information')->default(false);


            // Datos adicionales
            $table->string('photo_profile')->nullable()->comment('Foto de perfil del Usuario');

            // Campos de autenticación
            $table->string('password');
            $table->text('access_token')->nullable();
            $table->timestamp('token_expires_at')->nullable();
            $table->timestamp('last_login_at')->nullable();

            $table->rememberToken();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('students');
    }
};
