<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cycles', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->nullable()->unique();
            $table->string('slug')->nullable()->unique();
            $table->string('name')->unique();
            $table->year('year');
            $table->boolean('enrollment_open')->default(false)->comment('Abierta o cerrada la inscripción');
            $table->boolean('active')->default(false)->comment('Activa o inactiva el ciclo');
            $table->date('enrollment_start_date')->nullable()->comment('Fecha inicio inscripción'); // Fecha inicio inscripción
            $table->date('enrollment_end_date')->nullable()->comment('Fecha fin inscripción');   // Fecha fin inscripción
            $table->decimal('full_payment_cost', 10, 2)->default(0)
                ->comment('Costo pago completo (1 sola cuota)');
            $table->decimal('installment_cost', 10, 2)->default(0)
                ->comment('Costo pago fraccionado (2 cuotas)');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cycles');
    }
};
