<?php

namespace Database\Factories;

use App\Enums\Gender;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Teacher>
 */
class TeacherFactory extends Factory
{
    public function definition(): array
    {
        $faker = $this->faker;
        return [
            'document_number' => $faker->unique()->numerify('########'),
            'names' => $faker->firstName(),
            'paternal_surname' => $faker->lastName(),
            'maternal_surname' => $faker->lastName(),
            'gender' => $faker->randomElement(Gender::class),
            'birth_date' => $faker->date('Y-m-d', '-25 years'),
            'email' => $faker->unique()->safeEmail(),
            'phone_number' => $faker->phoneNumber(),
            'active' => $faker->boolean(80),
            'password' => 'password',
        ];
    }
}
