<?php

namespace App\Models;

use App\Traits\QueryScopeTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class School extends Model
{
    use HasFactory, QueryScopeTrait;

    protected $fillable = [
        'code',
        'name',
        'sector',
        'level',
        'ugel',
        'district_id',
        'validated'
    ];

    protected $casts = [
        'validated' => 'boolean'
    ];

    // Columnas donde se puede buscar (texto general)
    public array $searchable = ['name'];

    // Columnas por las que se puede ordenar
    public array $sortable = ['id', 'name'];

    // Relaciones que se pueden incluir
    public array $allowedIncludes = ['district', 'district.province', 'district.province.department', 'district.province.department.country'];

    // Columnas por las que se puede filtrar específicamente
    public array $filterable = ['validated'];

    //relaciones
    public function district()
    {
        return $this->belongsTo(District::class);
    }
}
