<?php

namespace App\Models;

use App\Traits\QueryScopeTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Permission extends Model
{
    use HasFactory, QueryScopeTrait;

    protected $fillable = [
        'name',
        'slug',
        'group',
        'description',
        'active',
    ];

    protected $casts = [
        'active' => 'boolean',
    ];

    // Columnas donde se puede buscar (texto general)
    public array $searchable = ['name', 'slug', 'group', 'description'];

    // Columnas por las que se puede ordenar
    public array $sortable = ['id', 'name', 'slug', 'group', 'description'];

    // Relaciones que se pueden incluir
    public array $allowedIncludes = ['roles'];

    // Columnas por las que se puede filtrar específicamente
    public array $filterable = ['name', 'slug', 'group', 'description'];

    // Relación con roles
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(Role::class, 'role_permissions')
            ->withTimestamps();
    }
}
