<?php

namespace App\Models;

use App\Traits\QueryScopeTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class District extends Model
{
    use HasFactory, QueryScopeTrait;

    protected $fillable = [
        'name',
        'province_id',
    ];

    // Columnas donde se puede buscar (texto general)
    public array $searchable = ['name'];

    // Columnas por las que se puede ordenar
    public array $sortable = ['id', 'name'];

    // Relaciones que se pueden incluir
    public array $allowedIncludes = ['province', 'province.department', 'province.department.country'];

    // Columnas por las que se puede filtrar específicamente
    public array $filterable = ['id', 'name'];

    // Relaciones
    public function province()
    {
        return $this->belongsTo(Province::class);
    }
}
