<?php

namespace App\Models;

use App\Traits\QueryScopeTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasFactory, QueryScopeTrait;

    protected $fillable = [
        'name',
        'country_id',
    ];

    // Columnas donde se puede buscar (texto general)
    public array $searchable = ['name'];

    // Columnas por las que se puede ordenar
    public array $sortable = ['id', 'name'];

    // Relaciones que se pueden incluir
    public array $allowedIncludes = ['country', 'provinces'];

    // Columnas por las que se puede filtrar específicamente
    public array $filterable = ['country_id', 'name'];

    // Relaciones
    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function provinces()
    {
        return $this->hasMany(Province::class);
    }
}
