<?php

namespace App\Models;

use App\Enums\CareerGroup;
use App\Traits\QueryScopeTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Career extends Model
{
    use HasFactory, QueryScopeTrait;

    protected $fillable = [
        'name',
        'code',
        'logo',
        'group',
        'active'
    ];

    protected $casts = [
        'group' => CareerGroup::class,
        'active' => 'boolean',
    ];

    // Columnas donde se puede buscar (texto general)
    public array $searchable = ['name', 'code'];

    // Columnas por las que se puede ordenar
    public array $sortable = ['id', 'name'];

    // Relaciones que se pueden incluir
    public array $allowedIncludes = ['enrollments'];

    // Columnas por las que se puede filtrar específicamente
    public array $filterable = ['group', 'active', 'name', 'code'];

    // Relaciones
    public function enrollments()
    {
        return $this->hasMany(Enrollment::class);
    }
}
