<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TeacherResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'document_number' => $this->document_number,
            'names' => $this->names,
            'paternal_surname' => $this->paternal_surname,
            'maternal_surname' => $this->maternal_surname,
            'full_name' => trim("{$this->names} {$this->paternal_surname} {$this->maternal_surname}"),
            'gender' => $this->gender?->value,
            'gender_label' => $this->gender?->label(),
            'birth_date' => $this->birth_date?->format('Y-m-d'),
            'email' => $this->email,
            'phone_number' => $this->phone_number,
            'photo_user' => $this->photo_teacher,
            'active' => $this->active,
            'access_token' => $this->plain_token,
            'token_expires_at' => $this->token_expires_at,
            // Roles (solo si están cargados)
            'roles' => RoleResource::collection($this->whenLoaded('roles')),
        ];
    }
}
