<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StudentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'user_type' => $this->getUserTypeAttribute(),

            // Documento
            'document_type' => $this->document_type?->value,
            'document_number' => $this->document_number,

            // Nombres
            'names' => $this->names,
            'paternal_surname' => $this->paternal_surname,
            'maternal_surname' => $this->maternal_surname,
            'full_name' => trim("{$this->names} {$this->paternal_surname} {$this->maternal_surname}"),

            // Información personal
            'birth_date' => $this->birth_date?->format('Y-m-d'),
            'birth_place_id' => $this->birth_place_id,
            'gender' => $this->gender?->value,
            'marital_status' => $this->marital_status?->value,
            'languages' => $this->languages,

            // Contacto
            'phone_number' => $this->phone_number,
            'whatsapp_number' => $this->whatsapp_number,
            'email' => $this->email,

            // Residencia
            'residence_address' => $this->residence_address,
            'residence_place_id' => $this->residence_place_id,

            // Escuela
            'school_id' => $this->school_id,
            'school_graduation_year' => $this->school_graduation_year,
            'school_graduation_certificate' => $this->school_graduation_certificate,

            // Familia
            'family_data' => $this->family_data,

            // Archivos
            'document_file' => $this->document_file,
            'photo_student' => $this->photo_student,
            'photo_profile' => $this->photo_profile,
            'photo_profile_url' => $this->getPhotoProfileUrlAttribute(),

            // Estados
            'active' => $this->active,
            'validated_information' => $this->validated_information,
            'last_login_at' => $this->last_login_at?->toISOString(),

            // Relaciones (solo si están cargadas)
            'residence_district' => DistrictResource::make($this->whenLoaded('residenceDistrict')),
            'birth_district' => DistrictResource::make($this->whenLoaded('birthDistrict')),
            'school' => SchoolResource::make($this->whenLoaded('school')),
            'enrollments' => EnrollmentResource::collection($this->whenLoaded('enrollments')),
        ];
    }
}
