<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SchoolResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        // return parent::toArray($request);

        return [
            'id' => $this->id,
            'code' => $this->code,
            'name' => $this->name,
            'sector' => $this->sector,
            'level' => $this->level,
            'ugel' => $this->ugel,
            'district_id' => $this->district_id,
            'validated' => $this->validated,
            'district' => DistrictResource::make($this->whenLoaded('district'))
        ];
    }
}
