<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DistrictResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        // return parent::toArray($request);

        return [
            'id' => $this->id,
            'name' => $this->name,
            'province_id' => $this->province_id,
            'province' => ProvinceResource::make($this->whenLoaded('province')),
            'schools' => SchoolResource::collection($this->whenLoaded('schools'))
        ];
    }
}
