<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PermissionRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        // $permissionId = $this->route('id')?->id;
        $permissionId = $this->route('id');

        return [
            'name' => ['required', 'string', 'min:3', 'max:100'],
            'slug' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:/^[a-z0-9._-]+$/',
                Rule::unique('permissions', 'slug')->ignore($permissionId),
            ],
            'group' => ['required', 'string', 'min:3', 'max:50'],
            'description' => ['nullable', 'string', 'max:500'],
            'active' => ['boolean'],
        ];
    }

    public function attributes(): array
    {
        return [
            'name' => 'Nombre',
            'slug' => 'Identificador',
            'group' => 'Grupo',
            'description' => 'Descripción',
            'active' => 'Activo',
        ];
    }
}
