<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class IndexQueryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'page' => 'sometimes|integer|min:1',
            'per_page' => 'sometimes|integer|min:1|max:100',
            'search' => 'sometimes|string|max:255',
            'sort' => 'sometimes|string|max:255',
            'sort_by' => 'sometimes|string|max:50',
            'order' => 'sometimes|string|in:asc,desc',
            'include' => 'sometimes|string|max:255',
            'filter' => 'sometimes|array',
            'filter.*' => 'sometimes|string|max:255',
        ];
    }

    public function attributes(): array
    {
        return [
            'page' => 'Página',
            'per_page' => 'Por página',
            'search' => 'Buscar',
            'sort' => 'Ordenar',
            'sort_by' => 'Ordenar por',
            'order' => 'Orden',
            'include' => 'Incluir',
            'filter' => 'Filtros',
            'filter.*' => 'Filtro',
        ];
    }
}
