<?php

namespace App\Http\Requests\Enrollment;

use App\Enums\GradeSchool;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SchoolDataRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $rules = [
            'school_id' => ['required', 'exists:schools,id'],
        ];

        if ($this->filled('school_graduation_year')) {
            $rules['school_graduation_year'] = ['digits:4', 'integer', 'min:1900', 'max:' . now()->year];
        } else {
            $rules['grade_school'] = ['required', Rule::enum(GradeSchool::class)];
        }

        return $rules;
    }

    public function attributes(): array
    {
        return [
            'school_id' => 'Colegio',
            'school_graduation_year' => 'Año de Egreso',
            'grade_school' => 'Grado',
        ];
    }
}
