<?php

namespace App\Http\Requests\Enrollment;

use App\Enums\DocumentType;
use App\Enums\Gender;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PersonalDataRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'document_type' => ['required', Rule::enum(DocumentType::class)],
            'document_number' => ['required', 'string', 'min:8', 'max:20'],
            'names' => ['required', 'string', 'min:2', 'max:255'],
            'paternal_surname' => ['required', 'string', 'min:2', 'max:255'],
            'maternal_surname' => ['required', 'string', 'min:2', 'max:255'],
            'birth_date' => ['required', 'date', 'before:today'],
            'gender' => ['required', Rule::enum(Gender::class)],
            'phone_number' => ['required', 'string', 'size:9'],
            'whatsapp_number' => ['required', 'string', 'size:9'],
            'email' => ['required', 'email', 'max:255'],
        ];
    }

    public function attributes(): array
    {
        return [
            'document_type' => 'Tipo de Documento',
            'document_number' => 'Número de Documento',
            'names' => 'Nombres',
            'paternal_surname' => 'Apellido Paterno',
            'maternal_surname' => 'Apellido Materno',
            'birth_date' => 'Fecha de Nacimiento',
            'gender' => 'Género',
            'phone_number' => 'Teléfono',
            'whatsapp_number' => 'WhatsApp',
            'email' => 'Email',
        ];
    }
}
