<?php

namespace App\Http\Requests\Enrollment;

use App\Enums\MaritalStatus;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class AdditionalDataRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'birth_place_id' => ['required', 'exists:districts,id'],
            'marital_status' => ['required', Rule::enum(MaritalStatus::class)],
            'languages' => ['required', 'array'],
            'residence_address' => ['required', 'string', 'min:2', 'max:255'],
            'residence_place_id' => ['required', 'exists:districts,id'],
        ];
    }

    public function attributes(): array
    {
        return [
            'birth_place_id' => 'Lugar de Nacimiento',
            'marital_status' => 'Estado Civil',
            'languages' => 'Idiomas',
            'residence_address' => 'Dirección',
            'residence_place_id' => 'Lugar de Residencia',
        ];
    }
}
