<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class DepartmentRequest extends FormRequest
{

    //Determine if the user is authorized to make this request.
    public function authorize(): bool
    {
        return true;
    }

    // Reglas de validación que se aplicarán a la petición
    public function rules(): array
    {
        $id = $this->route('id');
        return [
            'name' => [
                'required',
                'string',
                'min:3',
                'max:50',
                Rule::unique('departments', 'name')->ignore($id),
            ],
            'country_id' => [
                'required',
            ],
        ];
    }

    // Mensajes de validación
    public function attributes(): array
    {
        return [
            'name' => 'Nombre del Departamento',
            'country_id' => 'País',
        ];
    }
}
