<?php

namespace App\Http\Requests;

use App\Enums\CareerGroup;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CareerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    //Get the validation rules that apply to the request.

    public function rules(): array
    {
        $id = $this->route("id");
        return [
            "name" => [
                "required",
                "string",
                "min:3",
                "max:100",
                Rule::unique("careers", "name")->ignore($id)
            ],
            "code" => [
                "required",
                "string",
                "min:3",
                "max:20",
                Rule::unique("careers", "code")->ignore($id)
            ],
            "logo" => [
                "nullable",
                "string",
                "min:3",
                "max:100",
            ],
            "group" => [
                "required",
                Rule::enum(CareerGroup::class)
            ],
            "active" => [
                "required",
                "boolean"
            ]
        ];
    }

    public function attributes(): array
    {
        return [
            "name" => "Nombre",
            "code" => "Código",
            "logo" => "Logo",
            "group" => "Grupo",
            "active" => "Activo"
        ];
    }
}
