<?php

namespace App\Enums;

enum EnrollmentStatus: string
{
    case Pending = 'pending'; // Cuando esta en proceso de inscripción
    case Finished = 'finished'; // Cuando se ha finalizado la inscripción
    case Active = 'active'; // Cuando se ha Inicio el Ciclo
    case Cancelled = 'cancelled'; // Cuando se ha cancelado la inscripción o ciclo
    case Closed = 'closed'; // Cuando se ha Finalizado el Ciclo

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public function label(): string
    {
        return match ($this) {
            self::Pending => 'Pendiente',
            self::Finished => 'Finalizado',
            self::Active => 'Activo',
            self::Cancelled => 'Cancelado',
            self::Closed => 'Cerrado',
        };
    }
}
