<?php

namespace App\Enums;

enum DocumentType: string
{
    case DNI = 'dni';
    case Passport = 'passport';
    case ForeignerCard = 'foreigner_card';

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public function label(): string
    {
        return match ($this) {
            self::DNI => 'DNI',
            self::Passport => 'Pasaporte',
            self::ForeignerCard => 'Carnet de Extranjería',
        };
    }
}
