<?php

namespace App\Enums;

enum CareerGroup: string
{
    case A = 'a';
    case B = 'b';
    case C = 'c';
    case D = 'd';
    case E = 'e';

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public function label(): string
    {
        return match ($this) {
            self::A => 'Grupo A',
            self::B => 'Grupo B',
            self::C => 'Grupo C',
            self::D => 'Grupo D',
            self::E => 'Grupo E',
        };
    }
}
