<?php

use App\Http\Controllers\Api\Student\Enrollment\EnrollmentController;
use App\Http\Controllers\Api\Student\StudentAuthController;
use Illuminate\Support\Facades\Route;

// Autenticación
Route::post('/logout', [StudentAuthController::class, 'logout']);

// Perfil
Route::get('/profile', [StudentAuthController::class, 'profile']);
Route::put('/profile', [StudentAuthController::class, 'updateProfile']);

Route::patch('/change-password', [StudentAuthController::class, 'changePassword']);

// Proceso de matrícula
Route::prefix('enrollment')->group(function () {
    Route::post('/personal-data', [EnrollmentController::class, 'registerPersonalInformation']);
    Route::post('/additional-data', [EnrollmentController::class, 'registerAdditionalInformation']);
    Route::post('/family-data', [EnrollmentController::class, 'registerFamilyInformation']);
    Route::post('/school-data', [EnrollmentController::class, 'registerSchoolInformation']);
    Route::post('/career-data', [EnrollmentController::class, 'registerCareerInformation']);
    Route::post('/upload-document', [EnrollmentController::class, 'uploadDocument']);
    Route::post('/discount-type', [EnrollmentController::class, 'registerDiscount']);
    Route::post('/payment', [EnrollmentController::class, 'registerPayment']);
    Route::delete('/payment/{payment_id}', [EnrollmentController::class, 'deletePayment']);
    Route::post('/sworn-declaration', [EnrollmentController::class, 'swornDeclaration']);
    Route::post('/finish', [EnrollmentController::class, 'finishRegistration']);
});

// TODO: Agregar consulta de mis pagos
// TODO: Agregar consulta de mi historial académico
