<?php

use App\Http\Controllers\Api\Admin\CycleController;
use App\Http\Controllers\Api\Admin\UserController;
use App\Http\Controllers\Api\Student\StudentAuthController;
use App\Http\Controllers\Api\Teacher\TeacherAuthController;
use Illuminate\Support\Facades\Route;

// Rutas públicas de registro
Route::prefix('register')->group(function () {
    Route::get('/check-cycle', [CycleController::class, 'checkActiveCycle']);
    Route::post('/check-student', [StudentAuthController::class, 'checkStudent']);
    Route::post('/student', [StudentAuthController::class, 'register']);
});

// Autenticación (login público para todos)
Route::post('/admin/login', [UserController::class, 'login']);
Route::post('/teacher/login', [TeacherAuthController::class, 'login']);
Route::post('/student/login', [StudentAuthController::class, 'login']);

// Rutas compartidas
Route::group([], base_path('routes/api_shared.php'));

// Rutas por rol con prefijo y middleware
Route::middleware(['auth.admin'])->prefix('admin')->group(base_path('routes/api_admin.php'));
Route::middleware(['auth.teacher'])->prefix('teacher')->group(base_path('routes/api_teacher.php'));
Route::middleware(['auth.student'])->prefix('student')->group(base_path('routes/api_student.php'));

// routes/
// ├── api.php              # Solo: públicas + importar archivos
// ├── api_admin.php        # Exclusivo admins (CRUD sistemas)
// ├── api_teacher.php      # Exclusivo teachers (sus aulas)
// ├── api_student.php      # Exclusivo students (su matrícula)
// └── api_shared.php       # Catálogos de solo lectura (todos)
