<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
        // Rol Admin: tiene TODOS los permisos
        $adminRole = Role::create([
            'name' => 'Administrador',
            'slug' => 'admin',
            'description' => 'Acceso total al sistema',
            'active' => true,
        ]);

        // Asignar todos los permisos al admin
        $allPermissions = Permission::all();
        $adminRole->permissions()->attach($allPermissions->pluck('id'));

        // // Rol Teacher: permisos aleatorios (50-70% de los permisos)
        // $teacherRole = Role::create([
        //     'name' => 'Docente',
        //     'slug' => 'teacher',
        //     'description' => 'Docente con permisos limitados',
        //     'active' => true,
        // ]);

        // // Seleccionar permisos aleatorios para teacher (entre 50% y 70%)
        // $teacherPermissionsCount = rand(
        //     (int)($allPermissions->count() * 0.5),
        //     (int)($allPermissions->count() * 0.7)
        // );
        // $teacherPermissions = $allPermissions->random($teacherPermissionsCount);
        // $teacherRole->permissions()->attach($teacherPermissions->pluck('id'));

        // // Rol Student: permisos aleatorios (20-40% de los permisos)
        // $studentRole = Role::create([
        //     'name' => 'Estudiante',
        //     'slug' => 'student',
        //     'description' => 'Estudiante con permisos básicos',
        //     'active' => true,
        // ]);

        // // Seleccionar permisos aleatorios para student (entre 20% y 40%)
        // $studentPermissionsCount = rand(
        //     (int)($allPermissions->count() * 0.2),
        //     (int)($allPermissions->count() * 0.4)
        // );
        // $studentPermissions = $allPermissions->random($studentPermissionsCount);
        // $studentRole->permissions()->attach($studentPermissions->pluck('id'));
    }
}
