<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Province;
use Illuminate\Support\Facades\File;

class ProvinceSeeder extends Seeder
{
    public function run(): void
    {
        $json = File::get("database/json/provinces.json");
        $items = json_decode($json);

        foreach ($items as $key => $value) {
            Province::create([
                "id" => $value->id,
                "name" => $value->name,
                "department_id" => $value->department_id
            ]);
        }
    }
}
