<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\District;
use Illuminate\Support\Facades\File;

class DistrictSeeder extends Seeder
{
    public function run(): void
    {
        $json = File::get("database/json/districts.json");
        $items = json_decode($json);

        foreach ($items as $key => $value) {
            District::create([
                "id" => $value->id,
                "name" => $value->name,
                "province_id" => $value->province_id
            ]);
        }
    }
}
