<?php

namespace Database\Seeders;

use App\Models\Country;
use App\Models\Department;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class DepartmentSeeder extends Seeder
{
    public function run(): void
    {
        $json = File::get("database/json/departments.json");
        $items = json_decode($json);
        $country = Country::where('name', 'Perú')->first();

        foreach ($items as $key => $value) {
            Department::create([
                "id" => $value->id,
                "name" => $value->name,
                "country_id" => $country->id,
            ]);
        }
    }
}
