<?php

namespace Database\Seeders;

use App\Models\Country;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class CountrySeeder extends Seeder
{
    public function run(): void
    {
        $json = File::get("database/json/countries.json");
        $items = json_decode($json);

        foreach ($items as $key => $value) {
            Country::create([
                "name" => $value->es_name
            ]);
        }
    }
}
