<?php

use App\Enums\Gender;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();

            // Datos personales
            $table->string('document_number')->unique()->comment('DNI del usuario');
            $table->string('names');
            $table->string('paternal_surname');
            $table->string('maternal_surname');
            $table->enum('gender', Gender::values())->comment('Genero del usuario');
            $table->date('birth_date')->comment('Fecha de nacimiento del usuario');

            // Datos de contacto
            $table->string('email')->unique()->comment('Correo del usuario');
            $table->string('phone_number')->comment('Teléfono del usuario');

            // Datos adicionales
            $table->string('photo_profile')->nullable()->comment('Foto de perfil del Usuario');

            // Estados y control
            $table->boolean('active')->default(true)->comment('Activo o inactivo el usuario');

            // Campos de autenticación y sesión
            $table->string('password');
            $table->text('access_token')->nullable();
            $table->timestamp('token_expires_at')->nullable();
            $table->timestamp('last_login_at')->nullable();
            $table->rememberToken();

            // Timestamps
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
        // Schema::dropIfExists('password_reset_tokens');
        // Schema::dropIfExists('sessions');
    }
};
