<?php

/**
 * DICCIONARIO COMPLETO DE PERMISOS
 * 
 * Basado en un ERP/CRM empresarial real con gestión de:
 * - Usuarios y roles
 * - Clientes y proveedores
 * - Inventario y productos
 * - Ventas y facturación
 * - Compras y órdenes
 * - Finanzas y contabilidad
 * - Recursos humanos
 * - Reportes y analytics
 * - Configuración del sistema
 * 
 * Formato: recurso.accion (snake_case)
 */

return [
    // ========================================================================
    // 1. SISTEMA Y ADMINISTRACIÓN
    // ========================================================================
    'admin' => [
        'admin.access',              // Acceso al panel de administración
        'admin.super',               // Super administrador (bypass todo)
        'admin.view_logs',           // Ver logs del sistema
        'admin.clear_cache',         // Limpiar caché
        'admin.view_queue',          // Ver cola de trabajos
        'admin.manage_queue',        // Gestionar cola de trabajos
        'admin.run_commands',        // Ejecutar comandos artisan
        'admin.maintenance_mode',    // Activar modo mantenimiento
    ],

    // ========================================================================
    // 2. GESTIÓN DE USUARIOS
    // ========================================================================
    'users' => [
        'users.view',                // Ver listado de usuarios
        'users.show',                // Ver detalle de usuario
        'users.create',              // Crear usuario
        'users.edit',                // Editar usuario
        'users.delete',              // Eliminar usuario
        'users.restore',             // Restaurar usuario eliminado
        'users.force_delete',        // Eliminar permanentemente
        'users.toggle_status',       // Activar/desactivar usuario
        'users.reset_password',      // Resetear contraseña (admin)
        'users.change_password',     // Cambiar contraseña (propio)
        'users.impersonate',         // Suplantar usuario
        'users.lock',                // Bloquear cuenta
        'users.unlock',              // Desbloquear cuenta
        'users.assign_roles',        // Asignar roles
        'users.remove_roles',        // Quitar roles
        'users.view_permissions',    // Ver permisos del usuario
        'users.view_activity',       // Ver actividad del usuario
        'users.export',              // Exportar usuarios
        'users.import',              // Importar usuarios
        'users.bulk_delete',         // Eliminar múltiples
        'users.bulk_edit',           // Editar múltiples
    ],

    // ========================================================================
    // 3. ROLES Y PERMISOS
    // ========================================================================
    'roles' => [
        'roles.view',                // Ver roles
        'roles.show',                // Ver detalle de rol
        'roles.create',              // Crear rol
        'roles.edit',                // Editar rol
        'roles.delete',              // Eliminar rol
        'roles.assign_permissions',  // Asignar permisos al rol
        'roles.remove_permissions',  // Quitar permisos al rol
        'roles.sync_permissions',    // Sincronizar permisos
        'roles.toggle_status',       // Activar/desactivar rol
    ],

    'permissions' => [
        'permissions.view',          // Ver permisos
        'permissions.show',          // Ver detalle de permiso
        'permissions.create',        // Crear permiso
        'permissions.edit',          // Editar permiso
        'permissions.delete',        // Eliminar permiso
        'permissions.toggle_status', // Activar/desactivar permiso
        'permissions.view_groups',   // Ver grupos de permisos
    ],

    // ========================================================================
    // 4. CLIENTES (CRM)
    // ========================================================================
    'customers' => [
        'customers.view',            // Ver listado de clientes
        'customers.show',            // Ver detalle de cliente
        'customers.create',          // Crear cliente
        'customers.edit',            // Editar cliente
        'customers.delete',          // Eliminar cliente
        'customers.restore',         // Restaurar cliente eliminado
        'customers.toggle_status',   // Activar/desactivar cliente
        'customers.merge',           // Fusionar clientes duplicados
        'customers.export',          // Exportar clientes
        'customers.import',          // Importar clientes
        'customers.bulk_delete',     // Eliminar múltiples
        'customers.view_history',    // Ver historial de compras
        'customers.view_balance',    // Ver saldo/deuda
        'customers.add_note',        // Agregar nota al cliente
        'customers.view_notes',      // Ver notas del cliente
        'customers.send_email',      // Enviar email al cliente
        'customers.send_sms',        // Enviar SMS al cliente
    ],

    // ========================================================================
    // 5. PROVEEDORES
    // ========================================================================
    'suppliers' => [
        'suppliers.view',            // Ver proveedores
        'suppliers.show',            // Ver detalle de proveedor
        'suppliers.create',          // Crear proveedor
        'suppliers.edit',            // Editar proveedor
        'suppliers.delete',          // Eliminar proveedor
        'suppliers.toggle_status',   // Activar/desactivar proveedor
        'suppliers.view_balance',    // Ver cuentas por pagar
        'suppliers.add_note',        // Agregar nota
        'suppliers.export',          // Exportar proveedores
    ],

    // ========================================================================
    // 6. PRODUCTOS E INVENTARIO
    // ========================================================================
    'products' => [
        'products.view',             // Ver productos
        'products.show',             // Ver detalle de producto
        'products.create',           // Crear producto
        'products.edit',             // Editar producto
        'products.delete',           // Eliminar producto
        'products.restore',          // Restaurar producto
        'products.toggle_status',    // Activar/desactivar
        'products.view_stock',       // Ver stock
        'products.adjust_stock',     // Ajustar inventario
        'products.view_movements',   // Ver movimientos de stock
        'products.bulk_edit',        // Edición masiva
        'products.bulk_price_update', // Actualizar precios masivamente
        'products.export',           // Exportar productos
        'products.import',           // Importar productos
        'products.manage_variants',  // Gestionar variantes
        'products.manage_images',    // Gestionar imágenes
    ],

    'categories' => [
        'categories.view',           // Ver categorías
        'categories.create',         // Crear categoría
        'categories.edit',           // Editar categoría
        'categories.delete',         // Eliminar categoría
        'categories.reorder',        // Reordenar categorías
    ],

    'warehouses' => [
        'warehouses.view',           // Ver almacenes
        'warehouses.create',         // Crear almacén
        'warehouses.edit',           // Editar almacén
        'warehouses.delete',         // Eliminar almacén
        'warehouses.transfer_stock', // Transferir entre almacenes
    ],

    // ========================================================================
    // 7. VENTAS Y FACTURACIÓN
    // ========================================================================
    'sales' => [
        'sales.view',                // Ver ventas
        'sales.show',                // Ver detalle de venta
        'sales.create',              // Crear venta
        'sales.edit',                // Editar venta
        'sales.delete',              // Eliminar venta
        'sales.cancel',              // Cancelar venta
        'sales.approve',             // Aprobar venta
        'sales.reject',              // Rechazar venta
        'sales.apply_discount',      // Aplicar descuento
        'sales.print',               // Imprimir comprobante
        'sales.send_email',          // Enviar por email
        'sales.export',              // Exportar ventas
        'sales.view_profit',         // Ver ganancia/margen
    ],

    'invoices' => [
        'invoices.view',             // Ver facturas
        'invoices.show',             // Ver detalle de factura
        'invoices.create',           // Crear factura
        'invoices.edit',             // Editar factura
        'invoices.delete',           // Eliminar factura
        'invoices.cancel',           // Anular factura
        'invoices.send',             // Enviar factura
        'invoices.print',            // Imprimir factura
        'invoices.export',           // Exportar facturas
        'invoices.void',             // Anular fiscalmente
        'invoices.mark_paid',        // Marcar como pagada
        'invoices.send_reminder',    // Enviar recordatorio
    ],

    'quotations' => [
        'quotations.view',           // Ver cotizaciones
        'quotations.show',           // Ver detalle
        'quotations.create',         // Crear cotización
        'quotations.edit',           // Editar cotización
        'quotations.delete',         // Eliminar cotización
        'quotations.send',           // Enviar cotización
        'quotations.approve',        // Aprobar cotización
        'quotations.reject',         // Rechazar cotización
        'quotations.convert_to_sale', // Convertir a venta
        'quotations.duplicate',      // Duplicar cotización
    ],

    // ========================================================================
    // 8. COMPRAS
    // ========================================================================
    'purchases' => [
        'purchases.view',            // Ver compras
        'purchases.show',            // Ver detalle de compra
        'purchases.create',          // Crear compra
        'purchases.edit',            // Editar compra
        'purchases.delete',          // Eliminar compra
        'purchases.approve',         // Aprobar compra
        'purchases.reject',          // Rechazar compra
        'purchases.receive',         // Recibir mercancía
        'purchases.partial_receive', // Recepción parcial
        'purchases.export',          // Exportar compras
    ],

    'purchase_orders' => [
        'purchase_orders.view',      // Ver órdenes de compra
        'purchase_orders.create',    // Crear orden
        'purchase_orders.edit',      // Editar orden
        'purchase_orders.delete',    // Eliminar orden
        'purchase_orders.approve',   // Aprobar orden
        'purchase_orders.send',      // Enviar a proveedor
        'purchase_orders.cancel',    // Cancelar orden
    ],

    // ========================================================================
    // 9. FINANZAS Y CONTABILIDAD
    // ========================================================================
    'payments' => [
        'payments.view',             // Ver pagos
        'payments.show',             // Ver detalle de pago
        'payments.create',           // Registrar pago
        'payments.edit',             // Editar pago
        'payments.delete',           // Eliminar pago
        'payments.approve',          // Aprobar pago
        'payments.reject',           // Rechazar pago
        'payments.refund',           // Procesar reembolso
        'payments.verify',           // Verificar comprobante
        'payments.cancel',           // Cancelar pago
        'payments.export',           // Exportar pagos
        'payments.reconcile',        // Conciliar pagos
    ],

    'expenses' => [
        'expenses.view',             // Ver gastos
        'expenses.show',             // Ver detalle de gasto
        'expenses.create',           // Crear gasto
        'expenses.edit',             // Editar gasto
        'expenses.delete',           // Eliminar gasto
        'expenses.approve',          // Aprobar gasto
        'expenses.reject',           // Rechazar gasto
        'expenses.export',           // Exportar gastos
    ],

    'accounts' => [
        'accounts.view',             // Ver cuentas bancarias
        'accounts.create',           // Crear cuenta
        'accounts.edit',             // Editar cuenta
        'accounts.delete',           // Eliminar cuenta
        'accounts.view_balance',     // Ver saldo
        'accounts.view_movements',   // Ver movimientos
        'accounts.reconcile',        // Conciliar cuenta
    ],

    'transactions' => [
        'transactions.view',         // Ver transacciones
        'transactions.create',       // Crear transacción
        'transactions.edit',         // Editar transacción
        'transactions.delete',       // Eliminar transacción
        'transactions.approve',      // Aprobar transacción
        'transactions.export',       // Exportar transacciones
    ],

    // ========================================================================
    // 10. RECURSOS HUMANOS
    // ========================================================================
    'employees' => [
        'employees.view',            // Ver empleados
        'employees.show',            // Ver detalle de empleado
        'employees.create',          // Crear empleado
        'employees.edit',            // Editar empleado
        'employees.delete',          // Eliminar empleado
        'employees.toggle_status',   // Activar/desactivar
        'employees.view_salary',     // Ver salario
        'employees.edit_salary',     // Editar salario
        'employees.view_documents',  // Ver documentos
        'employees.upload_documents', // Subir documentos
        'employees.export',          // Exportar empleados
    ],

    'attendance' => [
        'attendance.view',           // Ver asistencias
        'attendance.take',           // Tomar asistencia
        'attendance.edit',           // Editar asistencia
        'attendance.approve',        // Aprobar asistencia
        'attendance.export',         // Exportar asistencias
        'attendance.view_reports',   // Ver reportes
    ],

    'payroll' => [
        'payroll.view',              // Ver nóminas
        'payroll.create',            // Crear nómina
        'payroll.edit',              // Editar nómina
        'payroll.delete',            // Eliminar nómina
        'payroll.approve',           // Aprobar nómina
        'payroll.process',           // Procesar nómina
        'payroll.export',            // Exportar nómina
        'payroll.send_payslips',     // Enviar recibos
    ],

    'leaves' => [
        'leaves.view',               // Ver vacaciones/permisos
        'leaves.create',             // Solicitar permiso
        'leaves.edit',               // Editar permiso
        'leaves.delete',             // Eliminar permiso
        'leaves.approve',            // Aprobar permiso
        'leaves.reject',             // Rechazar permiso
    ],

    // ========================================================================
    // 11. REPORTES Y ANALYTICS
    // ========================================================================
    'reports' => [
        'reports.sales',             // Reporte de ventas
        'reports.purchases',         // Reporte de compras
        'reports.inventory',         // Reporte de inventario
        'reports.financial',         // Reporte financiero
        'reports.customers',         // Reporte de clientes
        'reports.products',          // Reporte de productos
        'reports.profit_loss',       // Estado de resultados
        'reports.balance_sheet',     // Balance general
        'reports.cash_flow',         // Flujo de caja
        'reports.tax',               // Reporte de impuestos
        'reports.employees',         // Reporte de empleados
        'reports.attendance',        // Reporte de asistencias
        'reports.custom',            // Reportes personalizados
        'reports.export',            // Exportar reportes
        'reports.schedule',          // Programar reportes
        'reports.view_all',          // Ver todos los reportes
    ],

    'analytics' => [
        'analytics.view_dashboard',  // Ver dashboard principal
        'analytics.view_kpis',       // Ver indicadores clave
        'analytics.view_charts',     // Ver gráficos
        'analytics.export',          // Exportar analytics
    ],

    // ========================================================================
    // 12. CONFIGURACIÓN DEL SISTEMA
    // ========================================================================
    'settings' => [
        'settings.view',             // Ver configuración
        'settings.edit',             // Editar configuración
        'settings.company',          // Configuración de empresa
        'settings.billing',          // Configuración de facturación
        'settings.taxes',            // Configuración de impuestos
        'settings.email',            // Configuración de email
        'settings.sms',              // Configuración de SMS
        'settings.notifications',    // Configuración de notificaciones
        'settings.integrations',     // Configuración de integraciones
        'settings.backup',           // Crear backup
        'settings.restore',          // Restaurar backup
    ],

    'audit' => [
        'audit.view',                // Ver logs de auditoría
        'audit.export',              // Exportar logs
        'audit.delete',              // Eliminar logs antiguos
    ],

    // ========================================================================
    // 13. COMUNICACIÓN
    // ========================================================================
    'notifications' => [
        'notifications.send',        // Enviar notificaciones
        'notifications.broadcast',   // Enviar notificación masiva
        'notifications.view',        // Ver notificaciones
        'notifications.manage',      // Gestionar notificaciones
    ],

    'emails' => [
        'emails.send',               // Enviar emails
        'emails.send_bulk',          // Enviar emails masivos
        'emails.view_templates',     // Ver plantillas
        'emails.edit_templates',     // Editar plantillas
        'emails.view_queue',         // Ver cola de emails
    ],

    // ========================================================================
    // 14. ARCHIVOS Y DOCUMENTOS
    // ========================================================================
    'documents' => [
        'documents.view',            // Ver documentos
        'documents.upload',          // Subir documentos
        'documents.download',        // Descargar documentos
        'documents.delete',          // Eliminar documentos
        'documents.share',           // Compartir documentos
    ],

    // ========================================================================
    // 15. SOPORTE Y TICKETS
    // ========================================================================
    'tickets' => [
        'tickets.view',              // Ver tickets
        'tickets.view_all',          // Ver todos los tickets
        'tickets.view_own',          // Ver solo propios tickets
        'tickets.create',            // Crear ticket
        'tickets.edit',              // Editar ticket
        'tickets.delete',            // Eliminar ticket
        'tickets.assign',            // Asignar ticket
        'tickets.close',             // Cerrar ticket
        'tickets.reopen',            // Reabrir ticket
        'tickets.add_comment',       // Agregar comentario
    ],
];