<?php

namespace Database\Factories;

use App\Enums\DocumentType;
use App\Enums\Gender;
use App\Enums\MaritalStatus;
use App\Models\District;
use App\Models\School;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Carbon\Carbon;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Student>
 */
class StudentFactory extends Factory
{
    public function definition(): array
    {
        $faker = $this->faker;

        // Decidir si el estudiante tiene colegio o no
        $hasSchool = $faker->boolean(80); // 80% probabilidad de que sí tenga colegio

        $schoolGraduationYear = $hasSchool
            ? $faker->numberBetween(2000, 2025)
            : null;

        $schoolGraduationCertificate = $hasSchool
            ? 'certificates/' . Str::random(10) . '.pdf'
            : null;

        $schoolId = $hasSchool
            ? School::inRandomOrder()->first()?->id
            : null;

        return [
            'document_type' => $faker->randomElement(DocumentType::class),
            'document_number' => $faker->unique()->numerify('########'),
            'names' => $faker->firstName(),
            'paternal_surname' => $faker->lastName(),
            'maternal_surname' => $faker->lastName(),
            'birth_date' => $faker->date('Y-m-d', '-25 years'),
            'birth_place_id' => District::inRandomOrder()->first()?->id,
            'marital_status' => $faker->randomElement(MaritalStatus::class),
            'gender' => $faker->randomElement(Gender::class),
            'languages' => json_encode($faker->randomElements(['español', 'english', 'francés', 'quechua'], rand(1, 2))),
            'phone_number' => $faker->numerify('9########'),
            'whatsapp_number' => $faker->numerify('9########'),
            'email' => $faker->unique()->safeEmail(),
            'residence_address' => $faker->address(),
            'residence_place_id' => District::inRandomOrder()->first()?->id,
            'school_graduation_year' => $schoolGraduationYear,
            'school_graduation_certificate' => $schoolGraduationCertificate,
            'school_id' => School::inRandomOrder()->first()?->id,
            'family_data' => json_encode([
                [
                    'relationship' => fake()->randomElement(['father', 'mother', 'guardian']),
                    'names' => fake()->firstName(),
                    'paternal_surname' => fake()->lastName(),
                    'maternal_surname' => fake()->lastName(),
                    'birth_date' => fake()->date('Y-m-d', '-25 years'),
                    'gender' => fake()->randomElement(Gender::class),
                    'phone_number' => fake()->numerify('9########'),
                    'email' => fake()->unique()->safeEmail(),
                ],
                [
                    'relationship' => fake()->randomElement(['father', 'mother', 'guardian']),
                    'names' => fake()->firstName(),
                    'paternal_surname' => fake()->lastName(),
                    'maternal_surname' => fake()->lastName(),
                    'birth_date' => fake()->date('Y-m-d', '-25 years'),
                    'gender' => fake()->randomElement(Gender::class),
                    'phone_number' => fake()->numerify('9########'),
                    'email' => fake()->unique()->safeEmail(),
                ],
            ]),
            'document_file' => 'documents/' . Str::random(12) . '.pdf',
            // 'photo_student' => 'photos/' . Str::random(12) . '.jpg',
            'active' => true,
            'validated_information' => $faker->boolean(70),
            'password' => 'password' //Hash::make('password'),
        ];
    }
}
