<?php

return [
    /*
    |--------------------------------------------------------------------------
    | SISTEMA (system)
    |--------------------------------------------------------------------------
    */
    'permissions' => [
        ['name' => 'Listar Permisos', 'slug' => 'permissions.index', 'group' => 'system', 'description' => 'Listar Permisos', 'visible' => false],
        ['name' => 'Ver Permiso', 'slug' => 'permissions.show', 'group' => 'system', 'description' => 'Ver Permiso', 'visible' => false],
        ['name' => 'Crear Permiso', 'slug' => 'permissions.store', 'group' => 'system', 'description' => 'Crear Permiso', 'visible' => false],
        ['name' => 'Actualizar Permiso', 'slug' => 'permissions.update', 'group' => 'system', 'description' => 'Actualizar Permiso', 'visible' => false],
        ['name' => 'Eliminar Permiso', 'slug' => 'permissions.destroy', 'group' => 'system', 'description' => 'Eliminar Permiso', 'visible' => false],
    ],

    'roles' => [
        ['name' => 'Listar Roles', 'slug' => 'roles.index', 'group' => 'system', 'description' => 'Listar Roles', 'visible' => false],
        ['name' => 'Ver Rol', 'slug' => 'roles.show', 'group' => 'system', 'description' => 'Ver Rol', 'visible' => false],
        ['name' => 'Crear Rol', 'slug' => 'roles.store', 'group' => 'system', 'description' => 'Crear Rol', 'visible' => false],
        ['name' => 'Actualizar Rol', 'slug' => 'roles.update', 'group' => 'system', 'description' => 'Actualizar Rol', 'visible' => false],
        ['name' => 'Eliminar Rol', 'slug' => 'roles.destroy', 'group' => 'system', 'description' => 'Eliminar Rol', 'visible' => false],
        ['name' => 'Sincronizar Permisos', 'slug' => 'roles.permissions.sync', 'group' => 'system', 'description' => 'Sincronizar Permisos', 'visible' => false],
    ],

    /*
    |--------------------------------------------------------------------------
    | GEOGRAFÍA (geography)
    |--------------------------------------------------------------------------
    */
    'countries' => [
        ['name' => 'Listar Países', 'slug' => 'countries.index', 'group' => 'geography'],
        ['name' => 'Ver País', 'slug' => 'countries.show', 'group' => 'geography'],
        ['name' => 'Crear País', 'slug' => 'countries.store', 'group' => 'geography'],
        ['name' => 'Actualizar País', 'slug' => 'countries.update', 'group' => 'geography'],
        ['name' => 'Eliminar País', 'slug' => 'countries.destroy', 'group' => 'geography'],
    ],

    'departments' => [
        ['name' => 'Listar Departamentos', 'slug' => 'departments.index', 'group' => 'geography'],
        ['name' => 'Ver Departamento', 'slug' => 'departments.show', 'group' => 'geography'],
        ['name' => 'Crear Departamento', 'slug' => 'departments.store', 'group' => 'geography'],
        ['name' => 'Actualizar Departamento', 'slug' => 'departments.update', 'group' => 'geography'],
        ['name' => 'Eliminar Departamento', 'slug' => 'departments.destroy', 'group' => 'geography'],
    ],

    'provinces' => [
        ['name' => 'Listar Provincias', 'slug' => 'provinces.index', 'group' => 'geography'],
        ['name' => 'Ver Provincia', 'slug' => 'provinces.show', 'group' => 'geography'],
        ['name' => 'Crear Provincia', 'slug' => 'provinces.store', 'group' => 'geography'],
        ['name' => 'Actualizar Provincia', 'slug' => 'provinces.update', 'group' => 'geography'],
        ['name' => 'Eliminar Provincia', 'slug' => 'provinces.destroy', 'group' => 'geography'],
    ],

    'districts' => [
        ['name' => 'Listar Distritos', 'slug' => 'districts.index', 'group' => 'geography'],
        ['name' => 'Ver Distrito', 'slug' => 'districts.show', 'group' => 'geography'],
        ['name' => 'Crear Distrito', 'slug' => 'districts.store', 'group' => 'geography'],
        ['name' => 'Actualizar Distrito', 'slug' => 'districts.update', 'group' => 'geography'],
        ['name' => 'Eliminar Distrito', 'slug' => 'districts.destroy', 'group' => 'geography'],
    ],

    /*
    |--------------------------------------------------------------------------
    | INSTITUCIONAL (institutional)
    |--------------------------------------------------------------------------
    */
    'schools' => [
        ['name' => 'Listar Colegios', 'slug' => 'schools.index', 'group' => 'institutional'],
        ['name' => 'Ver Colegio', 'slug' => 'schools.show', 'group' => 'institutional'],
        ['name' => 'Crear Colegio', 'slug' => 'schools.store', 'group' => 'institutional'],
        ['name' => 'Actualizar Colegio', 'slug' => 'schools.update', 'group' => 'institutional'],
        ['name' => 'Eliminar Colegio', 'slug' => 'schools.destroy', 'group' => 'institutional'],
    ],

    'careers' => [
        ['name' => 'Listar Carreras', 'slug' => 'careers.index', 'group' => 'institutional'],
        ['name' => 'Ver Carrera', 'slug' => 'careers.show', 'group' => 'institutional'],
        ['name' => 'Crear Carrera', 'slug' => 'careers.store', 'group' => 'institutional'],
        ['name' => 'Actualizar Carrera', 'slug' => 'careers.update', 'group' => 'institutional'],
        ['name' => 'Eliminar Carrera', 'slug' => 'careers.destroy', 'group' => 'institutional'],
    ],

    /*
    |--------------------------------------------------------------------------
    | USUARIOS (users)
    |--------------------------------------------------------------------------
    */
    'users' => [
        ['name' => 'Listar Usuarios', 'slug' => 'users.index', 'group' => 'users'],
        ['name' => 'Ver Usuario', 'slug' => 'users.show', 'group' => 'users'],
        ['name' => 'Crear Usuario', 'slug' => 'users.store', 'group' => 'users'],
        ['name' => 'Actualizar Usuario', 'slug' => 'users.update', 'group' => 'users'],
        ['name' => 'Eliminar Usuario', 'slug' => 'users.destroy', 'group' => 'users'],
        ['name' => 'Cambiar Estado Usuario', 'slug' => 'users.toggle-status', 'group' => 'users'],
        ['name' => 'Asignar Roles', 'slug' => 'users.roles.assign', 'group' => 'users'],
        ['name' => 'Restablecer Contraseña', 'slug' => 'users.password.force-reset', 'group' => 'users'],
    ],

    'students' => [
        ['name' => 'Listar Estudiantes', 'slug' => 'students.index', 'group' => 'users'],
        ['name' => 'Ver Estudiante', 'slug' => 'students.show', 'group' => 'users'],
        ['name' => 'Crear Estudiante', 'slug' => 'students.store', 'group' => 'users'],
        ['name' => 'Actualizar Estudiante', 'slug' => 'students.update', 'group' => 'users'],
        ['name' => 'Eliminar Estudiante', 'slug' => 'students.destroy', 'group' => 'users'],
        ['name' => 'Validar Matrícula', 'slug' => 'students.enrollment.validate', 'group' => 'users'],
        ['name' => 'Importar Estudiantes', 'slug' => 'students.import', 'group' => 'users'],
        ['name' => 'Exportar Estudiantes', 'slug' => 'students.export', 'group' => 'users'],
    ],

    /*
    |--------------------------------------------------------------------------
    | ACADÉMICO (academic)
    |--------------------------------------------------------------------------
    */
    'cycles' => [
        // Gestión de Ciclos
        ['name' => 'Listar Ciclos', 'slug' => 'cycles.index', 'group' => 'academic'],
        ['name' => 'Ver Ciclo', 'slug' => 'cycles.show', 'group' => 'academic'],
        ['name' => 'Crear Ciclo', 'slug' => 'cycles.store', 'group' => 'academic'],
        ['name' => 'Actualizar Ciclo', 'slug' => 'cycles.update', 'group' => 'academic'],
        ['name' => 'Eliminar Ciclo', 'slug' => 'cycles.destroy', 'group' => 'academic'],
        ['name' => 'Cambiar Estado Ciclo', 'slug' => 'cycles.toggle-active', 'group' => 'academic'],
        ['name' => 'Cambiar Estado Inscripción', 'slug' => 'cycles.toggle-enrollment', 'group' => 'academic'],

        // Gestión de Matrículas (Enrollments)
        ['name' => 'Listar Matriculados', 'slug' => 'enrollments.index', 'group' => 'academic'],
        ['name' => 'Ver Detalle de Matrícula', 'slug' => 'enrollments.show', 'group' => 'academic'],
        ['name' => 'Editar Matrícula', 'slug' => 'enrollments.update', 'group' => 'academic'],
        ['name' => 'Cambiar Estado de Matrícula', 'slug' => 'enrollments.toggle-status', 'group' => 'academic'],

        // Gestión de Pagos de Matrículas
        ['name' => 'Ver Historial de Pagos', 'slug' => 'enrollments.payments.index', 'group' => 'academic'],
        ['name' => 'Ver Detalle de Pago', 'slug' => 'enrollments.payments.show', 'group' => 'academic'],
        ['name' => 'Registrar Pago', 'slug' => 'enrollments.payments.store', 'group' => 'academic'],
        ['name' => 'Actualizar Pago', 'slug' => 'enrollments.payments.update', 'group' => 'academic'],
        ['name' => 'Eliminar Pago', 'slug' => 'enrollments.payments.destroy', 'group' => 'academic'],
        ['name' => 'Actualizar Estado Pago', 'slug' => 'enrollments.payments.toggle-status', 'group' => 'academic'],
    ],

    /*
    |--------------------------------------------------------------------------
    | FINANZAS (financial)
    |--------------------------------------------------------------------------
    */
    'discount_types' => [
        ['name' => 'Listar Tipos de Descuento', 'slug' => 'discount-types.index', 'group' => 'financial'],
        ['name' => 'Ver Tipo de Descuento', 'slug' => 'discount-types.show', 'group' => 'financial'],
        ['name' => 'Crear Tipo de Descuento', 'slug' => 'discount-types.store', 'group' => 'financial'],
        ['name' => 'Actualizar Tipo de Descuento', 'slug' => 'discount-types.update', 'group' => 'financial'],
        ['name' => 'Eliminar Tipo de Descuento', 'slug' => 'discount-types.destroy', 'group' => 'financial'],
    ],

    /*
    |--------------------------------------------------------------------------
    | PERFIL (profile)
    |--------------------------------------------------------------------------
    */
    'profile' => [
        ['name' => 'Ver Mi Perfil', 'slug' => 'profile.show', 'group' => 'profile'],
        ['name' => 'Actualizar Mi Perfil', 'slug' => 'profile.update', 'group' => 'profile'],
        ['name' => 'Cambiar Mi Contraseña', 'slug' => 'profile.password.change', 'group' => 'profile'],
    ],
];
