<?php

namespace App\Traits;

use App\Models\Cycle;
use Illuminate\Http\Exceptions\HttpResponseException;

trait AppHelpers
{
    /**
     * Verificar que existe un ciclo activo y agregarlo al request
     * Útil cuando se usa en FormRequests
     */
    protected function ensureActiveCycle()
    {
        $cycle = Cycle::getLastActive();

        if (!$cycle) {
            throw new HttpResponseException(
                response()->json([
                    'success' => false,
                    'message' => 'No se ha encontrado un Ciclo Activo',
                ], 400)
            );
        }

        $this->merge(['cycle' => $cycle->toArray()]);
    }

    /**
     * Obtener el ciclo activo directamente
     * Útil cuando se usa en Controllers
     */
    protected function getActiveCycle()
    {
        $cycle = Cycle::getLastActive();

        if (!$cycle) {
            throw new HttpResponseException(
                response()->json([
                    'success' => false,
                    'message' => 'No se ha encontrado un Ciclo Activo',
                ], 400)
            );
        }

        return $cycle;
    }

    /**
     * Obtener la matrícula activa de un estudiante
     * Útil cuando se usa en Controllers
     * 
     * @param \App\Models\Student $student
     * @return \App\Models\Enrollment
     */
    protected function getActiveEnrollment($student)
    {
        $enrollment = $student->latestEnrollmentActive;

        if (!$enrollment) {
            throw new HttpResponseException(
                response()->json([
                    'success' => false,
                    'message' => 'No se ha encontrado una Matrícula Activa',
                ], 400)
            );
        }

        return $enrollment;
    }
}
